<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('received', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->string('rid', 255);
            $table->string('did', 255);
            $table->tinyInteger('sim')->default(1);
            $table->string('phone', 50);
            $table->text('message');
            $table->timestamp('receive_date')->useCurrent();
            
            $table->index('uid');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('received');
    }
};
