<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('actions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->integer('sid')->nullable();
            $table->tinyInteger('type');
            $table->tinyInteger('source');
            $table->tinyInteger('event');
            $table->tinyInteger('priority');
            $table->tinyInteger('match');
            $table->integer('ai_key')->default(0);
            $table->text('ai_plugins')->nullable();
            $table->tinyInteger('group_trigger')->default(0);
            $table->tinyInteger('sim')->default(1);
            $table->text('device')->nullable();
            $table->text('account')->nullable();
            $table->text('link')->nullable();
            $table->string('name', 255);
            $table->text('keywords')->nullable();
            $table->text('message');
            $table->timestamp('create_date')->useCurrent();
            
            $table->index('uid');
            $table->index('type');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('actions');
    }
};
