<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('wa_received', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->string('wid', 255);
            $table->text('unique');
            $table->string('phone', 50);
            $table->text('group')->nullable();
            $table->text('message');
            $table->timestamp('receive_date')->useCurrent();
            $table->boolean('is_read')->default(false);
            $table->dateTime('read_at')->nullable();
            $table->integer('read_by')->nullable();
            $table->integer('first_responder_id')->nullable()->comment('معرف أول من رد');
            $table->string('message_id', 100)->nullable();
            $table->string('quoted_message_id', 100)->nullable();
            $table->text('quoted_text')->nullable();
            $table->string('quoted_sender', 50)->nullable();
            $table->string('wa_name', 255)->nullable();
            $table->string('wa_profile_pic', 500)->nullable();
            $table->string('group_name', 255)->nullable();
            $table->string('group_profile_pic', 500)->nullable();
            $table->string('sender_name', 255)->nullable();
            $table->string('media_url', 500)->nullable();
            $table->boolean('is_deleted')->default(false);
            $table->boolean('is_edited')->default(false);
            
            $table->index('uid');
            $table->index('phone');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('wa_received');
    }
};
