<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('wa_groups', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->string('wid', 255);
            $table->string('gid', 100);
            $table->string('name', 255);
            $table->timestamp('create_date')->useCurrent();
            
            $table->index('uid');
            $table->index('gid');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('wa_groups');
    }
};
