<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('wa_contact_info', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->string('phone', 50);
            $table->string('wa_name', 255)->nullable();
            $table->string('wa_profile_pic', 500)->nullable();
            $table->timestamp('updated_at')->useCurrent();
            
            $table->index(['uid', 'phone']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('wa_contact_info');
    }
};
