<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('vouchers', function (Blueprint $table) {
            $table->id();
            $table->string('code', 50)->unique();
            $table->tinyInteger('type')->default(1);
            $table->float('value');
            $table->timestamp('create_date')->useCurrent();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('vouchers');
    }
};
