<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('payouts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->float('amount');
            $table->string('currency', 10);
            $table->string('provider', 50);
            $table->string('address', 255);
            $table->timestamp('create_date')->useCurrent();
            
            $table->index('uid');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('payouts');
    }
};
