<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('ussd', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->string('did', 255);
            $table->tinyInteger('sim')->default(1);
            $table->string('code', 50);
            $table->text('response')->nullable();
            $table->tinyInteger('status')->default(1);
            $table->timestamp('create_date')->useCurrent();
            
            $table->index('uid');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ussd');
    }
};
