<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('flows', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->string('name', 255);
            $table->string('source', 50)->default('whatsapp');
            $table->longText('flow_data');
            $table->timestamp('create_date')->useCurrent();
            
            $table->index('uid');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('flows');
    }
};
