<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // AI Keys
        Schema::create('ai_keys', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->text('name');
            $table->text('prompt');
            $table->text('post_prompt')->nullable();
            $table->string('model', 100);
            $table->integer('history')->default(0);
            $table->integer('max_tokens')->default(1000);
            $table->tinyInteger('vision')->default(0);
            $table->tinyInteger('transcription')->default(0);
            $table->text('apikey')->nullable();
            $table->timestamp('create_date')->useCurrent();
            
            $table->index('uid');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ai_keys');
    }
};
