<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('ai_plugins', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->string('name', 255);
            $table->longText('schema');
            $table->text('endpoint');
            $table->timestamp('create_date')->useCurrent();
            
            $table->index('uid');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ai_plugins');
    }
};
