<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('staff', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->string('name', 255);
            $table->string('email', 255);
            $table->string('password', 255);
            $table->text('permissions');
            $table->tinyInteger('status')->default(1);
            $table->timestamp('last_login')->nullable();
            $table->timestamp('create_date')->useCurrent();
            
            $table->index('uid');
            $table->index('email');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('staff');
    }
};
