<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('messenger_settings', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid')->unique();
            $table->boolean('hide_numbers')->default(false);
            $table->boolean('hide_chats_from_staff')->default(false);
            $table->boolean('first_responder_owns')->default(false);
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            
            $table->index('uid');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('messenger_settings');
    }
};
