<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('messenger_number_exceptions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->integer('staff_id');
            $table->timestamp('created_at')->useCurrent();
            
            $table->index(['uid', 'staff_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('messenger_number_exceptions');
    }
};
