<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('hidden_conversations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->string('phone', 50);
            $table->integer('hidden_by')->comment('User ID who hid this conversation');
            $table->timestamp('created_at')->useCurrent();
            
            $table->unique(['uid', 'phone', 'hidden_by']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('hidden_conversations');
    }
};
