<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class RoleSeeder extends Seeder
{
    public function run(): void
    {
        $roles = [
            [
                'id' => 1,
                'name' => 'Administrator',
                'permissions' => json_encode([
                    'manage_users' => true,
                    'manage_packages' => true,
                    'manage_roles' => true,
                    'manage_settings' => true,
                    'manage_gateways' => true,
                    'manage_plugins' => true,
                    'view_reports' => true,
                    'manage_pages' => true,
                    'manage_languages' => true,
                ]),
            ],
            [
                'id' => 2,
                'name' => 'User',
                'permissions' => json_encode([
                    'send_sms' => true,
                    'send_whatsapp' => true,
                    'manage_contacts' => true,
                    'manage_templates' => true,
                    'manage_devices' => true,
                    'manage_api_keys' => true,
                    'view_reports' => true,
                ]),
            ],
            [
                'id' => 3,
                'name' => 'Reseller',
                'permissions' => json_encode([
                    'send_sms' => true,
                    'send_whatsapp' => true,
                    'manage_contacts' => true,
                    'manage_templates' => true,
                    'manage_devices' => true,
                    'manage_api_keys' => true,
                    'view_reports' => true,
                    'manage_staff' => true,
                    'manage_subusers' => true,
                ]),
            ],
        ];

        foreach ($roles as $role) {
            DB::table('roles')->updateOrInsert(['id' => $role['id']], $role);
        }
    }
}
