<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        // Import users from the legacy database
        // These are the actual users from flywhats_database.sql
        $users = [
            [
                'id' => 1,
                'role' => 1,
                'email' => 'admin@flywhats.com',
                'password' => Hash::make('admin123'), // Default password - should be changed
                'credits' => 0,
                'earnings' => 0,
                'name' => 'FLY WHATS',
                'country' => 'AE',
                'language' => 1,
                'theme_color' => 'light',
                'providers' => '',
                'alertsound' => 1,
                'suspended' => 0,
                'timezone' => 'asia/dubai',
                'formatting' => json_encode([
                    'clock' => 'g:i A',
                    'date' => 'n/j/Y',
                    'container' => [
                        'clock_format' => 1,
                        'date_format' => 1,
                        'date_separator' => 2,
                        'separator_selected' => '/'
                    ]
                ]),
                'partner' => 1,
                'confirmed' => 1,
                'create_date' => '2025-11-22 19:08:11',
                'avatar' => null,
            ],
            [
                'id' => 2,
                'role' => 1,
                'email' => 'admin@rentcarshow.com',
                'password' => Hash::make('demo123'),
                'credits' => 10000000000000,
                'earnings' => 0,
                'name' => 'Rentcarshow',
                'country' => 'AE',
                'language' => 1,
                'theme_color' => 'light',
                'providers' => '',
                'alertsound' => 1,
                'suspended' => 0,
                'timezone' => 'asia/dubai',
                'formatting' => json_encode([
                    'clock' => 'g:i A',
                    'date' => 'j-n-Y',
                    'container' => [
                        'clock_format' => 1,
                        'date_format' => 2,
                        'date_separator' => 1,
                        'separator_selected' => '-'
                    ]
                ]),
                'partner' => 2,
                'confirmed' => 1,
                'create_date' => '2025-11-22 21:30:04',
                'avatar' => null,
            ],
            [
                'id' => 3,
                'role' => 1,
                'email' => 'ghantoot@ghantoot.com',
                'password' => Hash::make('demo123'),
                'credits' => 10000000000000,
                'earnings' => 0,
                'name' => 'GHANTOOT RENT-A CAR',
                'country' => 'AE',
                'language' => 1,
                'theme_color' => 'light',
                'providers' => '',
                'alertsound' => 1,
                'suspended' => 0,
                'timezone' => 'asia/dubai',
                'formatting' => json_encode([
                    'clock' => 'g:i A',
                    'date' => 'j-n-Y',
                    'container' => [
                        'clock_format' => 1,
                        'date_format' => 2,
                        'date_separator' => 1,
                        'separator_selected' => '-'
                    ]
                ]),
                'partner' => 2,
                'confirmed' => 1,
                'create_date' => '2025-11-22 21:47:58',
                'avatar' => null,
            ],
            [
                'id' => 4,
                'role' => 1,
                'email' => 'admin@saifaljazera.com',
                'password' => Hash::make('demo123'),
                'credits' => 10000000000000,
                'earnings' => 0,
                'name' => 'Saif Aljazera',
                'country' => 'AE',
                'language' => 1,
                'theme_color' => 'light',
                'providers' => '',
                'alertsound' => 1,
                'suspended' => 0,
                'timezone' => 'asia/dubai',
                'formatting' => json_encode([
                    'clock' => 'g:i A',
                    'date' => 'j-n-Y',
                    'container' => [
                        'clock_format' => 1,
                        'date_format' => 2,
                        'date_separator' => 1,
                        'separator_selected' => '-'
                    ]
                ]),
                'partner' => 2,
                'confirmed' => 1,
                'create_date' => '2025-11-24 20:01:20',
                'avatar' => null,
            ],
            [
                'id' => 5,
                'role' => 1,
                'email' => 'admin@fishgourmet.ae',
                'password' => Hash::make('demo123'),
                'credits' => 10000000000000,
                'earnings' => 0,
                'name' => 'fishgourmet',
                'country' => 'AE',
                'language' => 1,
                'theme_color' => 'light',
                'providers' => '',
                'alertsound' => 1,
                'suspended' => 0,
                'timezone' => 'asia/dubai',
                'formatting' => json_encode([
                    'clock' => 'g:i A',
                    'date' => 'j-n-Y',
                    'container' => [
                        'clock_format' => 1,
                        'date_format' => 2,
                        'date_separator' => 1,
                        'separator_selected' => '-'
                    ]
                ]),
                'partner' => 2,
                'confirmed' => 1,
                'create_date' => '2025-11-26 19:22:47',
                'avatar' => null,
            ],
        ];

        foreach ($users as $user) {
            DB::table('users')->updateOrInsert(['id' => $user['id']], $user);
        }

        // Create subscriptions for users
        $subscriptions = [
            ['id' => 1, 'uid' => 1, 'pid' => 4, 'tid' => 1, 'date' => now()->addYear()],
            ['id' => 2, 'uid' => 2, 'pid' => 4, 'tid' => 2, 'date' => now()->addYear()],
            ['id' => 3, 'uid' => 3, 'pid' => 4, 'tid' => 3, 'date' => now()->addYear()],
            ['id' => 4, 'uid' => 4, 'pid' => 4, 'tid' => 4, 'date' => now()->addYear()],
            ['id' => 5, 'uid' => 5, 'pid' => 4, 'tid' => 5, 'date' => now()->addYear()],
        ];

        foreach ($subscriptions as $sub) {
            DB::table('subscriptions')->updateOrInsert(['id' => $sub['id']], $sub);
        }

        // Create transactions
        $transactions = [
            ['id' => 1, 'uid' => 1, 'pid' => 4, 'type' => 'subscription', 'provider' => 'manual', 'ref' => 'INIT-1', 'price' => 0, 'currency' => 'USD', 'duration' => 365],
            ['id' => 2, 'uid' => 2, 'pid' => 4, 'type' => 'subscription', 'provider' => 'manual', 'ref' => 'INIT-2', 'price' => 0, 'currency' => 'USD', 'duration' => 365],
            ['id' => 3, 'uid' => 3, 'pid' => 4, 'type' => 'subscription', 'provider' => 'manual', 'ref' => 'INIT-3', 'price' => 0, 'currency' => 'USD', 'duration' => 365],
            ['id' => 4, 'uid' => 4, 'pid' => 4, 'type' => 'subscription', 'provider' => 'manual', 'ref' => 'INIT-4', 'price' => 0, 'currency' => 'USD', 'duration' => 365],
            ['id' => 5, 'uid' => 5, 'pid' => 4, 'type' => 'subscription', 'provider' => 'manual', 'ref' => 'INIT-5', 'price' => 0, 'currency' => 'USD', 'duration' => 365],
        ];

        foreach ($transactions as $trans) {
            DB::table('transactions')->updateOrInsert(['id' => $trans['id']], $trans);
        }
    }
}
