<!-- Gateway Rates Modals -->
@foreach($gateways ?? [] as $gateway)
<div class="modal fade" id="ratesModal{{ $gateway->id }}" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('gateway_rates') }}: {{ $gateway->name }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.gateways.rates', $gateway->id) }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('default_rate') }}</label>
                        <input type="number" name="default_rate" class="form-control" step="0.0001" value="{{ $gateway->default_rate ?? 0 }}">
                    </div>
                    <hr>
                    <h6>{{ __('country_rates') }}</h6>
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>{{ __('country') }}</th>
                                    <th>{{ __('rate') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($countries ?? [] as $code => $country)
                                <tr>
                                    <td>{{ $country }}</td>
                                    <td>
                                        <input type="number" name="rates[{{ $code }}]" class="form-control form-control-sm" step="0.0001" value="{{ $gateway->rates[$code] ?? '' }}" placeholder="{{ __('use_default') }}">
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('save_rates') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endforeach
