@extends('layouts.admin')

@section('title', __('dashboard_admin_tablanguagestitle'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">{{ __('dashboard_admin_tablanguagestitle') }}</h5>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addLanguageModal">
                        <i class="bi bi-plus-lg"></i> {{ __('add_language') }}
                    </button>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped" id="languagesTable">
                            <thead>
                                <tr>
                                    <th>{{ __('id') }}</th>
                                    <th>{{ __('name') }}</th>
                                    <th>{{ __('code') }}</th>
                                    <th>{{ __('rtl') }}</th>
                                    <th>{{ __('default') }}</th>
                                    <th>{{ __('actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($languages ?? [] as $language)
                                <tr>
                                    <td>{{ $language->id }}</td>
                                    <td>{{ $language->name }}</td>
                                    <td><code>{{ $language->code }}</code></td>
                                    <td>
                                        @if($language->rtl)
                                            <span class="badge bg-info">RTL</span>
                                        @else
                                            <span class="badge bg-secondary">LTR</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($language->is_default)
                                            <span class="badge bg-success">{{ __('default') }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#translateModal{{ $language->id }}">
                                            <i class="bi bi-translate"></i>
                                        </button>
                                        <button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#editLanguageModal{{ $language->id }}">
                                            <i class="bi bi-pencil"></i>
                                        </button>
                                        @if(!$language->is_default)
                                        <button class="btn btn-sm btn-danger" onclick="deleteLanguage({{ $language->id }})">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                        @endif
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center">{{ __('no_data') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('admin.languages.modals.add')
@include('admin.languages.modals.edit')
@include('admin.languages.modals.translate')
@endsection
