<!-- Edit Language Modals -->
@foreach($languages ?? [] as $language)
<div class="modal fade" id="editLanguageModal{{ $language->id }}" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('edit_language') }}: {{ $language->name }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.languages.update', $language->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('name') }}</label>
                        <input type="text" name="name" class="form-control" value="{{ $language->name }}" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('code') }}</label>
                        <input type="text" name="code" class="form-control" value="{{ $language->code }}" maxlength="5" required>
                    </div>
                    <div class="form-check mb-3">
                        <input type="checkbox" name="rtl" class="form-check-input" value="1" {{ $language->rtl ? 'checked' : '' }}>
                        <label class="form-check-label">{{ __('rtl_language') }}</label>
                    </div>
                    <div class="form-check mb-3">
                        <input type="checkbox" name="is_default" class="form-check-input" value="1" {{ $language->is_default ? 'checked' : '' }}>
                        <label class="form-check-label">{{ __('set_as_default') }}</label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('update') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endforeach
