@extends('layouts.admin')

@section('title', __('and_admin_mark_3'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">{{ __('and_admin_mark_3') }}</h5>
                </div>
                <div class="card-body">
                    <ul class="nav nav-tabs" id="marketingTabs">
                        <li class="nav-item">
                            <a class="nav-link active" data-bs-toggle="tab" href="#emailTab">{{ __('email_campaigns') }}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#notifyTab">{{ __('push_notifications') }}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#mailerTab">{{ __('mailer_settings') }}</a>
                        </li>
                    </ul>
                    
                    <div class="tab-content mt-4">
                        <!-- Email Campaigns Tab -->
                        <div class="tab-pane fade show active" id="emailTab">
                            <div class="d-flex justify-content-between mb-3">
                                <h6>{{ __('email_campaigns') }}</h6>
                                <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#sendEmailModal">
                                    <i class="bi bi-envelope"></i> {{ __('send_email') }}
                                </button>
                            </div>
                            <form action="{{ route('admin.marketing.email') }}" method="POST">
                                @csrf
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('target_users') }}</label>
                                        <select name="target" class="form-control" required>
                                            <option value="all">{{ __('all_users') }}</option>
                                            <option value="active">{{ __('active_subscribers') }}</option>
                                            <option value="inactive">{{ __('inactive_users') }}</option>
                                            <option value="expired">{{ __('expired_subscriptions') }}</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('subject') }}</label>
                                        <input type="text" name="subject" class="form-control" required>
                                    </div>
                                    <div class="col-12 mb-3">
                                        <label class="form-label">{{ __('message') }}</label>
                                        <textarea name="message" class="form-control" rows="6" required></textarea>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary">{{ __('send_campaign') }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        
                        <!-- Push Notifications Tab -->
                        <div class="tab-pane fade" id="notifyTab">
                            <div class="d-flex justify-content-between mb-3">
                                <h6>{{ __('push_notifications') }}</h6>
                            </div>
                            <form action="{{ route('admin.marketing.notify') }}" method="POST">
                                @csrf
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('target_users') }}</label>
                                        <select name="target" class="form-control" required>
                                            <option value="all">{{ __('all_users') }}</option>
                                            <option value="specific">{{ __('specific_user') }}</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('user_id') }}</label>
                                        <input type="number" name="user_id" class="form-control" placeholder="{{ __('leave_empty_for_all') }}">
                                    </div>
                                    <div class="col-12 mb-3">
                                        <label class="form-label">{{ __('notification_message') }}</label>
                                        <textarea name="message" class="form-control" rows="4" required></textarea>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary">{{ __('send_notification') }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        
                        <!-- Mailer Settings Tab -->
                        <div class="tab-pane fade" id="mailerTab">
                            <h6 class="mb-3">{{ __('mailer_settings') }}</h6>
                            <form action="{{ route('admin.marketing.mailer') }}" method="POST">
                                @csrf
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('mail_driver') }}</label>
                                        <select name="mail_driver" class="form-control">
                                            <option value="smtp">SMTP</option>
                                            <option value="mailgun">Mailgun</option>
                                            <option value="ses">Amazon SES</option>
                                            <option value="sendmail">Sendmail</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('mail_host') }}</label>
                                        <input type="text" name="mail_host" class="form-control" value="{{ config('mail.mailers.smtp.host') }}">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('mail_port') }}</label>
                                        <input type="number" name="mail_port" class="form-control" value="{{ config('mail.mailers.smtp.port') }}">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('mail_username') }}</label>
                                        <input type="text" name="mail_username" class="form-control" value="{{ config('mail.mailers.smtp.username') }}">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('mail_password') }}</label>
                                        <input type="password" name="mail_password" class="form-control">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('mail_encryption') }}</label>
                                        <select name="mail_encryption" class="form-control">
                                            <option value="tls">TLS</option>
                                            <option value="ssl">SSL</option>
                                            <option value="">None</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('mail_from_address') }}</label>
                                        <input type="email" name="mail_from_address" class="form-control" value="{{ config('mail.from.address') }}">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('mail_from_name') }}</label>
                                        <input type="text" name="mail_from_name" class="form-control" value="{{ config('mail.from.name') }}">
                                    </div>
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary">{{ __('save_settings') }}</button>
                                        <button type="button" class="btn btn-secondary" onclick="testMailer()">{{ __('test_mailer') }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
