<!-- Edit Package Modals -->
@foreach($packages ?? [] as $package)
<div class="modal fade" id="editPackageModal{{ $package->id }}" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('edit_package') }}: {{ $package->name }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.packages.update', $package->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('name') }}</label>
                            <input type="text" name="name" class="form-control" value="{{ $package->name }}" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('price') }}</label>
                            <input type="number" name="price" class="form-control" step="0.01" value="{{ $package->price }}" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('duration') }} ({{ __('days') }})</label>
                            <input type="number" name="duration" class="form-control" value="{{ $package->duration }}" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('send_limit') }}</label>
                            <input type="number" name="send_limit" class="form-control" value="{{ $package->send_limit }}">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('receive_limit') }}</label>
                            <input type="number" name="receive_limit" class="form-control" value="{{ $package->receive_limit }}">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('device_limit') }}</label>
                            <input type="number" name="device_limit" class="form-control" value="{{ $package->device_limit }}">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('contact_limit') }}</label>
                            <input type="number" name="contact_limit" class="form-control" value="{{ $package->contact_limit }}">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('wa_account_limit') }}</label>
                            <input type="number" name="wa_account_limit" class="form-control" value="{{ $package->wa_account_limit }}">
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label">{{ __('services') }}</label>
                            <select name="services[]" class="form-control" multiple>
                                @php $packageServices = explode(',', $package->services ?? ''); @endphp
                                <option value="sms" {{ in_array('sms', $packageServices) ? 'selected' : '' }}>SMS</option>
                                <option value="whatsapp" {{ in_array('whatsapp', $packageServices) ? 'selected' : '' }}>WhatsApp</option>
                                <option value="api" {{ in_array('api', $packageServices) ? 'selected' : '' }}>API</option>
                                <option value="webhooks" {{ in_array('webhooks', $packageServices) ? 'selected' : '' }}>Webhooks</option>
                                <option value="actions" {{ in_array('actions', $packageServices) ? 'selected' : '' }}>Actions</option>
                                <option value="templates" {{ in_array('templates', $packageServices) ? 'selected' : '' }}>Templates</option>
                                <option value="flows" {{ in_array('flows', $packageServices) ? 'selected' : '' }}>Flows</option>
                                <option value="ai" {{ in_array('ai', $packageServices) ? 'selected' : '' }}>AI</option>
                            </select>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label">{{ __('description') }}</label>
                            <textarea name="description" class="form-control" rows="3">{{ $package->description }}</textarea>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-check">
                                <input type="checkbox" name="status" class="form-check-input" value="1" {{ $package->status ? 'checked' : '' }}>
                                <label class="form-check-label">{{ __('active') }}</label>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-check">
                                <input type="checkbox" name="hidden" class="form-check-input" value="1" {{ $package->hidden ? 'checked' : '' }}>
                                <label class="form-check-label">{{ __('hidden') }}</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('update') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endforeach
