@extends('layouts.admin')

@section('title', __('dashboard_pages_title'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">{{ __('dashboard_pages_title') }}</h5>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addPageModal">
                        <i class="bi bi-plus-lg"></i> {{ __('add_page') }}
                    </button>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped" id="pagesTable">
                            <thead>
                                <tr>
                                    <th>{{ __('id') }}</th>
                                    <th>{{ __('name') }}</th>
                                    <th>{{ __('slug') }}</th>
                                    <th>{{ __('roles') }}</th>
                                    <th>{{ __('status') }}</th>
                                    <th>{{ __('actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($pages ?? [] as $page)
                                <tr>
                                    <td>{{ $page->id }}</td>
                                    <td>{{ $page->name }}</td>
                                    <td><code>{{ $page->slug }}</code></td>
                                    <td>{{ $page->roles_count ?? 'All' }}</td>
                                    <td>
                                        @if($page->status)
                                            <span class="badge bg-success">{{ __('active') }}</span>
                                        @else
                                            <span class="badge bg-danger">{{ __('inactive') }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('dashboard.pages.show', [$page->id, $page->slug]) }}" target="_blank" class="btn btn-sm btn-secondary">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                        <button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#editPageModal{{ $page->id }}">
                                            <i class="bi bi-pencil"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" onclick="deletePage({{ $page->id }})">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center">{{ __('no_data') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('admin.pages.modals.add')
@include('admin.pages.modals.edit')
@endsection
