@extends('layouts.admin')

@section('title', __('and_admin_payout_3'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">{{ __('and_admin_payout_3') }}</h5>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-4">
                            <div class="card bg-warning text-dark">
                                <div class="card-body">
                                    <h4>{{ $stats['pending'] ?? 0 }}</h4>
                                    <p class="mb-0">{{ __('pending_payouts') }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card bg-success text-white">
                                <div class="card-body">
                                    <h4>{{ $stats['approved'] ?? 0 }}</h4>
                                    <p class="mb-0">{{ __('approved_payouts') }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card bg-danger text-white">
                                <div class="card-body">
                                    <h4>{{ $stats['rejected'] ?? 0 }}</h4>
                                    <p class="mb-0">{{ __('rejected_payouts') }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="table-responsive">
                        <table class="table table-striped" id="payoutsTable">
                            <thead>
                                <tr>
                                    <th>{{ __('id') }}</th>
                                    <th>{{ __('user') }}</th>
                                    <th>{{ __('amount') }}</th>
                                    <th>{{ __('method') }}</th>
                                    <th>{{ __('status') }}</th>
                                    <th>{{ __('date') }}</th>
                                    <th>{{ __('actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($payouts ?? [] as $payout)
                                <tr>
                                    <td>#{{ $payout->id }}</td>
                                    <td>{{ $payout->user->name ?? 'N/A' }}</td>
                                    <td>{{ number_format($payout->amount, 2) }}</td>
                                    <td>{{ $payout->method }}</td>
                                    <td>
                                        @if($payout->status == 'pending')
                                            <span class="badge bg-warning">{{ __('pending') }}</span>
                                        @elseif($payout->status == 'approved')
                                            <span class="badge bg-success">{{ __('approved') }}</span>
                                        @else
                                            <span class="badge bg-danger">{{ __('rejected') }}</span>
                                        @endif
                                    </td>
                                    <td>{{ $payout->created_at->format('Y-m-d H:i') }}</td>
                                    <td>
                                        @if($payout->status == 'pending')
                                        <button class="btn btn-sm btn-success" onclick="approvePayout({{ $payout->id }})">
                                            <i class="bi bi-check"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" onclick="rejectPayout({{ $payout->id }})">
                                            <i class="bi bi-x"></i>
                                        </button>
                                        @endif
                                        <button class="btn btn-sm btn-info" onclick="viewPayout({{ $payout->id }})">
                                            <i class="bi bi-eye"></i>
                                        </button>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center">{{ __('no_data') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    {{ $payouts->links() ?? '' }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
