<!-- Edit Role Modals -->
@foreach($roles ?? [] as $role)
@if($role->id > 1)
<div class="modal fade" id="editRoleModal{{ $role->id }}" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('edit_role') }}: {{ $role->name }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.roles.update', $role->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('name') }}</label>
                        <input type="text" name="name" class="form-control" value="{{ $role->name }}" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('permissions') }}</label>
                        @php
                        $rolePermissions = explode(',', $role->permissions ?? '');
                        $allPermissions = [
                            'manage_users' => __('manage_users'),
                            'manage_packages' => __('manage_packages'),
                            'manage_subscriptions' => __('manage_subscriptions'),
                            'manage_vouchers' => __('manage_vouchers'),
                            'manage_transactions' => __('manage_transactions'),
                            'manage_payouts' => __('manage_payouts'),
                            'manage_pages' => __('manage_pages'),
                            'manage_marketing' => __('manage_marketing'),
                            'manage_languages' => __('manage_languages'),
                            'manage_waservers' => __('manage_waservers'),
                            'manage_gateways' => __('manage_gateways'),
                            'manage_shorteners' => __('manage_shorteners'),
                            'manage_plugins' => __('manage_plugins'),
                            'manage_settings' => __('manage_settings'),
                            'manage_api' => __('manage_api'),
                        ];
                        @endphp
                        <div class="row">
                            @foreach($allPermissions as $key => $label)
                            <div class="col-md-6">
                                <div class="form-check">
                                    <input type="checkbox" name="permissions[]" class="form-check-input" value="{{ $key }}" {{ in_array($key, $rolePermissions) ? 'checked' : '' }}>
                                    <label class="form-check-label">{{ $label }}</label>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('update') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endif
@endforeach
