@extends('layouts.admin')

@section('title', __('dashboard_admin_tabtransactionstitle'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">{{ __('dashboard_admin_tabtransactionstitle') }}</h5>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="card bg-success text-white">
                                <div class="card-body">
                                    <h4>{{ $stats['total_amount'] ?? '0.00' }}</h4>
                                    <p class="mb-0">{{ __('total_revenue') }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-primary text-white">
                                <div class="card-body">
                                    <h4>{{ $stats['completed'] ?? 0 }}</h4>
                                    <p class="mb-0">{{ __('completed') }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-warning text-dark">
                                <div class="card-body">
                                    <h4>{{ $stats['pending'] ?? 0 }}</h4>
                                    <p class="mb-0">{{ __('pending') }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-danger text-white">
                                <div class="card-body">
                                    <h4>{{ $stats['failed'] ?? 0 }}</h4>
                                    <p class="mb-0">{{ __('failed') }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="table-responsive">
                        <table class="table table-striped" id="transactionsTable">
                            <thead>
                                <tr>
                                    <th>{{ __('id') }}</th>
                                    <th>{{ __('user') }}</th>
                                    <th>{{ __('amount') }}</th>
                                    <th>{{ __('type') }}</th>
                                    <th>{{ __('gateway') }}</th>
                                    <th>{{ __('status') }}</th>
                                    <th>{{ __('date') }}</th>
                                    <th>{{ __('actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($transactions ?? [] as $transaction)
                                <tr>
                                    <td>#{{ $transaction->id }}</td>
                                    <td>{{ $transaction->user->name ?? 'N/A' }}</td>
                                    <td>{{ number_format($transaction->amount, 2) }}</td>
                                    <td>{{ $transaction->type }}</td>
                                    <td>{{ $transaction->gateway }}</td>
                                    <td>
                                        @if($transaction->status == 'completed')
                                            <span class="badge bg-success">{{ __('completed') }}</span>
                                        @elseif($transaction->status == 'pending')
                                            <span class="badge bg-warning">{{ __('pending') }}</span>
                                        @else
                                            <span class="badge bg-danger">{{ __('failed') }}</span>
                                        @endif
                                    </td>
                                    <td>{{ $transaction->created_at->format('Y-m-d H:i') }}</td>
                                    <td>
                                        <button class="btn btn-sm btn-info" onclick="viewTransaction({{ $transaction->id }})">
                                            <i class="bi bi-eye"></i>
                                        </button>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center">{{ __('no_data') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    {{ $transactions->links() ?? '' }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
