@extends('layouts.admin')

@section('title', __('edit_user'))

@section('content')
<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">{{ __('edit_user') }}: {{ $user->name }}</h5>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.users.update', $user->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">{{ __('name') }}</label>
                        <input type="text" name="name" class="form-control" value="{{ $user->name }}" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">{{ __('email') }}</label>
                        <input type="email" name="email" class="form-control" value="{{ $user->email }}" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">{{ __('role') }}</label>
                        <select name="role" class="form-control" required>
                            @foreach($roles ?? [] as $role)
                            <option value="{{ $role->id }}" {{ $user->role == $role->id ? 'selected' : '' }}>{{ $role->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">{{ __('credits') }}</label>
                        <input type="number" name="credits" class="form-control" step="0.01" value="{{ $user->credits }}">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">{{ __('new_password') }} ({{ __('optional') }})</label>
                        <input type="password" name="password" class="form-control">
                    </div>
                    <div class="col-md-6 mb-3">
                        <div class="form-check mt-4">
                            <input type="checkbox" name="suspended" class="form-check-input" value="1" {{ $user->suspended ? 'checked' : '' }}>
                            <label class="form-check-label">{{ __('suspended') }}</label>
                        </div>
                    </div>
                    <div class="col-12">
                        <button type="submit" class="btn btn-primary">{{ __('save_changes') }}</button>
                        <a href="{{ route('admin.users.index') }}" class="btn btn-secondary">{{ __('cancel') }}</a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
