<!-- Add Voucher Modal -->
<div class="modal fade" id="addVoucherModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('add_voucher') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.vouchers.store') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('code') }}</label>
                        <div class="input-group">
                            <input type="text" name="code" id="voucherCode" class="form-control" required>
                            <button type="button" class="btn btn-outline-secondary" onclick="generateCode()">
                                <i class="bi bi-shuffle"></i>
                            </button>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('package') }}</label>
                        <select name="pid" class="form-control">
                            <option value="">{{ __('all_packages') }}</option>
                            @foreach($packages ?? [] as $package)
                            <option value="{{ $package->id }}">{{ $package->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('discount_type') }}</label>
                        <select name="type" class="form-control" required>
                            <option value="percentage">{{ __('percentage') }}</option>
                            <option value="fixed">{{ __('fixed_amount') }}</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('discount') }}</label>
                        <input type="number" name="discount" class="form-control" step="0.01" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('max_uses') }}</label>
                        <input type="number" name="max_uses" class="form-control" placeholder="{{ __('unlimited') }}">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('expires_at') }}</label>
                        <input type="date" name="expires_at" class="form-control">
                    </div>
                    <div class="form-check mb-3">
                        <input type="checkbox" name="status" class="form-check-input" value="1" checked>
                        <label class="form-check-label">{{ __('active') }}</label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('save') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function generateCode() {
    const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    let code = '';
    for (let i = 0; i < 8; i++) {
        code += chars.charAt(Math.floor(Math.random() * chars.length));
    }
    document.getElementById('voucherCode').value = code;
}
</script>
