<!-- Edit WA Server Modals -->
@foreach($waservers ?? [] as $server)
<div class="modal fade" id="editWaServerModal{{ $server->id }}" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('edit_waserver') }}: {{ $server->name }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.waservers.update', $server->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('name') }}</label>
                        <input type="text" name="name" class="form-control" value="{{ $server->name }}" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('url') }}</label>
                        <input type="text" name="url" class="form-control" value="{{ $server->url }}" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('port') }}</label>
                        <input type="number" name="port" class="form-control" value="{{ $server->port }}" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('secret') }}</label>
                        <input type="text" name="secret" class="form-control" value="{{ $server->secret }}" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('max_accounts') }}</label>
                        <input type="number" name="max_accounts" class="form-control" value="{{ $server->max_accounts }}">
                    </div>
                    <div class="form-check mb-3">
                        <input type="checkbox" name="status" class="form-check-input" value="1" {{ $server->status ? 'checked' : '' }}>
                        <label class="form-check-label">{{ __('active') }}</label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('update') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endforeach
