@extends('layouts.auth')

@section('title', __('Forgot Password'))

@section('content')
<div class="auth-card">
    <div class="auth-logo">
        <i class="bi bi-lock text-primary" style="font-size: 3rem;"></i>
        <h2>{{ __('Forgot Password') }}</h2>
        <p class="text-muted">{{ __('Enter your email to receive a reset link') }}</p>
    </div>

    @if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <form method="POST" action="{{ route('password.email') }}">
        @csrf
        <div class="mb-3">
            <label for="email" class="form-label">{{ __('Email Address') }}</label>
            <input type="email" class="form-control @error('email') is-invalid @enderror" 
                   id="email" name="email" value="{{ old('email') }}" required autofocus>
            @error('email')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <button type="submit" class="btn btn-primary w-100 mb-3">
            <i class="bi bi-envelope me-2"></i>{{ __('Send Reset Link') }}
        </button>
    </form>

    <div class="text-center mt-3">
        <a href="{{ route('login') }}" class="text-decoration-none">{{ __('Back to Login') }}</a>
    </div>
</div>
@endsection
