@extends('layouts.auth')

@section('title', __('Register'))

@section('content')
<div class="auth-card">
    <div class="auth-logo">
        <i class="bi bi-whatsapp text-success" style="font-size: 3rem;"></i>
        <h2>FlyWhats</h2>
        <p class="text-muted">{{ __('Create your account') }}</p>
    </div>

    <form method="POST" action="{{ route('register') }}">
        @csrf
        
        <div class="mb-3">
            <label for="name" class="form-label">{{ __('Full Name') }}</label>
            <input type="text" class="form-control @error('name') is-invalid @enderror" 
                   id="name" name="name" value="{{ old('name') }}" required autofocus>
            @error('name')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label for="email" class="form-label">{{ __('Email Address') }}</label>
            <input type="email" class="form-control @error('email') is-invalid @enderror" 
                   id="email" name="email" value="{{ old('email') }}" required>
            @error('email')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label for="country" class="form-label">{{ __('Country') }}</label>
            <select class="form-control @error('country') is-invalid @enderror" id="country" name="country" required>
                <option value="">{{ __('Select Country') }}</option>
                <option value="AE" {{ old('country') == 'AE' ? 'selected' : '' }}>United Arab Emirates</option>
                <option value="SA" {{ old('country') == 'SA' ? 'selected' : '' }}>Saudi Arabia</option>
                <option value="US" {{ old('country') == 'US' ? 'selected' : '' }}>United States</option>
                <option value="GB" {{ old('country') == 'GB' ? 'selected' : '' }}>United Kingdom</option>
            </select>
            @error('country')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label for="password" class="form-label">{{ __('Password') }}</label>
            <input type="password" class="form-control @error('password') is-invalid @enderror" 
                   id="password" name="password" required>
            @error('password')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label for="password_confirmation" class="form-label">{{ __('Confirm Password') }}</label>
            <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" required>
        </div>

        <button type="submit" class="btn btn-primary w-100 mb-3">
            <i class="bi bi-person-plus me-2"></i>{{ __('Create Account') }}
        </button>
    </form>

    <hr class="my-4">

    <div class="text-center">
        <span class="text-muted">{{ __('Already have an account?') }}</span>
        <a href="{{ route('login') }}" class="text-decoration-none ms-1">{{ __('Sign In') }}</a>
    </div>
</div>
@endsection
