<!-- Charts Widget -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h6 class="mb-0">{{ $title ?? __('chart') }}</h6>
        <div class="btn-group btn-group-sm">
            <button type="button" class="btn btn-outline-secondary active" data-period="7">7 {{ __('days') }}</button>
            <button type="button" class="btn btn-outline-secondary" data-period="30">30 {{ __('days') }}</button>
            <button type="button" class="btn btn-outline-secondary" data-period="90">90 {{ __('days') }}</button>
        </div>
    </div>
    <div class="card-body">
        <canvas id="{{ $chartId ?? 'chart' }}" height="300"></canvas>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const ctx = document.getElementById('{{ $chartId ?? 'chart' }}').getContext('2d');
    const chart = new Chart(ctx, {
        type: '{{ $type ?? 'line' }}',
        data: {
            labels: {!! json_encode($labels ?? []) !!},
            datasets: [{
                label: '{{ $datasetLabel ?? __('data') }}',
                data: {!! json_encode($data ?? []) !!},
                borderColor: '{{ $color ?? '#007bff' }}',
                backgroundColor: '{{ $backgroundColor ?? 'rgba(0, 123, 255, 0.1)' }}',
                fill: {{ $fill ?? 'true' }},
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
</script>
@endpush
