<!-- Header Block -->
<header class="header" id="header">
    <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm">
        <div class="container-fluid">
            <button class="btn btn-link" id="sidebarToggle">
                <i class="bi bi-list fs-4"></i>
            </button>
            
            <div class="d-flex align-items-center ms-auto">
                <!-- Notifications -->
                <div class="dropdown me-3">
                    <button class="btn btn-link position-relative" data-bs-toggle="dropdown">
                        <i class="bi bi-bell fs-5"></i>
                        @if($unreadNotifications ?? 0)
                        <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                            {{ $unreadNotifications }}
                        </span>
                        @endif
                    </button>
                    <div class="dropdown-menu dropdown-menu-end" style="width: 300px;">
                        <h6 class="dropdown-header">{{ __('notifications') }}</h6>
                        @forelse($notifications ?? [] as $notification)
                        <a class="dropdown-item" href="#">
                            <small class="text-muted">{{ $notification->created_at->diffForHumans() }}</small>
                            <p class="mb-0">{{ $notification->message }}</p>
                        </a>
                        @empty
                        <p class="dropdown-item text-muted mb-0">{{ __('no_notifications') }}</p>
                        @endforelse
                    </div>
                </div>
                
                <!-- Language Selector -->
                <div class="dropdown me-3">
                    <button class="btn btn-link" data-bs-toggle="dropdown">
                        <i class="bi bi-globe fs-5"></i>
                    </button>
                    <div class="dropdown-menu dropdown-menu-end">
                        @foreach($languages ?? [] as $lang)
                        <a class="dropdown-item {{ app()->getLocale() == $lang->code ? 'active' : '' }}" href="{{ route('language.switch', $lang->code) }}">
                            {{ $lang->name }}
                        </a>
                        @endforeach
                    </div>
                </div>
                
                <!-- User Menu -->
                <div class="dropdown">
                    <button class="btn btn-link d-flex align-items-center" data-bs-toggle="dropdown">
                        <img src="{{ auth()->user()->avatar ?? asset('images/default-avatar.png') }}" class="rounded-circle me-2" width="32" height="32">
                        <span class="d-none d-md-inline">{{ auth()->user()->name ?? 'User' }}</span>
                        <i class="bi bi-chevron-down ms-1"></i>
                    </button>
                    <div class="dropdown-menu dropdown-menu-end">
                        <a class="dropdown-item" href="{{ route('dashboard.profile') }}">
                            <i class="bi bi-person me-2"></i> {{ __('profile') }}
                        </a>
                        <a class="dropdown-item" href="{{ route('dashboard.misc.packages') }}">
                            <i class="bi bi-box me-2"></i> {{ __('subscription') }}
                        </a>
                        <div class="dropdown-divider"></div>
                        <form action="{{ route('logout') }}" method="POST">
                            @csrf
                            <button type="submit" class="dropdown-item text-danger">
                                <i class="bi bi-box-arrow-right me-2"></i> {{ __('logout') }}
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </nav>
</header>
