<!-- Sidebar Block -->
<aside class="sidebar" id="sidebar">
    <div class="sidebar-header">
        <a href="{{ route('dashboard') }}" class="sidebar-brand">
            <img src="{{ asset($settings['logo'] ?? 'images/logo.png') }}" alt="{{ $settings['site_name'] ?? config('app.name') }}" height="40">
        </a>
    </div>
    
    <nav class="sidebar-nav">
        <ul class="nav flex-column">
            <li class="nav-item">
                <a href="{{ route('dashboard') }}" class="nav-link {{ request()->routeIs('dashboard') ? 'active' : '' }}">
                    <i class="bi bi-speedometer2"></i>
                    <span>{{ __('dashboard') }}</span>
                </a>
            </li>
            
            @if(in_array('whatsapp', $services ?? []))
            <li class="nav-item">
                <a href="#whatsappMenu" class="nav-link" data-bs-toggle="collapse">
                    <i class="bi bi-whatsapp"></i>
                    <span>{{ __('whatsapp') }}</span>
                    <i class="bi bi-chevron-down ms-auto"></i>
                </a>
                <div class="collapse" id="whatsappMenu">
                    <ul class="nav flex-column ms-3">
                        <li><a href="{{ route('dashboard.whatsapp.queue') }}" class="nav-link">{{ __('queue') }}</a></li>
                        <li><a href="{{ route('dashboard.whatsapp.sent') }}" class="nav-link">{{ __('sent') }}</a></li>
                        <li><a href="{{ route('dashboard.whatsapp.received') }}" class="nav-link">{{ __('received') }}</a></li>
                        <li><a href="{{ route('dashboard.whatsapp.campaigns') }}" class="nav-link">{{ __('campaigns') }}</a></li>
                        <li><a href="{{ route('dashboard.whatsapp.scheduled') }}" class="nav-link">{{ __('scheduled') }}</a></li>
                        <li><a href="{{ route('dashboard.whatsapp.groups') }}" class="nav-link">{{ __('groups') }}</a></li>
                    </ul>
                </div>
            </li>
            @endif
            
            @if(in_array('sms', $services ?? []))
            <li class="nav-item">
                <a href="#smsMenu" class="nav-link" data-bs-toggle="collapse">
                    <i class="bi bi-chat-dots"></i>
                    <span>{{ __('sms') }}</span>
                    <i class="bi bi-chevron-down ms-auto"></i>
                </a>
                <div class="collapse" id="smsMenu">
                    <ul class="nav flex-column ms-3">
                        <li><a href="{{ route('dashboard.sms.queue') }}" class="nav-link">{{ __('queue') }}</a></li>
                        <li><a href="{{ route('dashboard.sms.sent') }}" class="nav-link">{{ __('sent') }}</a></li>
                        <li><a href="{{ route('dashboard.sms.received') }}" class="nav-link">{{ __('received') }}</a></li>
                        <li><a href="{{ route('dashboard.sms.campaigns') }}" class="nav-link">{{ __('campaigns') }}</a></li>
                        <li><a href="{{ route('dashboard.sms.scheduled') }}" class="nav-link">{{ __('scheduled') }}</a></li>
                    </ul>
                </div>
            </li>
            @endif
            
            <li class="nav-item">
                <a href="#contactsMenu" class="nav-link" data-bs-toggle="collapse">
                    <i class="bi bi-people"></i>
                    <span>{{ __('contacts') }}</span>
                    <i class="bi bi-chevron-down ms-auto"></i>
                </a>
                <div class="collapse" id="contactsMenu">
                    <ul class="nav flex-column ms-3">
                        <li><a href="{{ route('dashboard.contacts.index') }}" class="nav-link">{{ __('saved') }}</a></li>
                        <li><a href="{{ route('dashboard.contacts.groups') }}" class="nav-link">{{ __('groups') }}</a></li>
                        <li><a href="{{ route('dashboard.contacts.tags') }}" class="nav-link">{{ __('tags') }}</a></li>
                        <li><a href="{{ route('dashboard.contacts.sources') }}" class="nav-link">{{ __('sources') }}</a></li>
                        <li><a href="{{ route('dashboard.contacts.unsubscribed') }}" class="nav-link">{{ __('unsubscribed') }}</a></li>
                    </ul>
                </div>
            </li>
            
            <li class="nav-item">
                <a href="#hostsMenu" class="nav-link" data-bs-toggle="collapse">
                    <i class="bi bi-hdd-stack"></i>
                    <span>{{ __('hosts') }}</span>
                    <i class="bi bi-chevron-down ms-auto"></i>
                </a>
                <div class="collapse" id="hostsMenu">
                    <ul class="nav flex-column ms-3">
                        @if(in_array('sms', $services ?? []))
                        <li><a href="{{ route('dashboard.hosts.android') }}" class="nav-link">{{ __('android_devices') }}</a></li>
                        @endif
                        @if(in_array('whatsapp', $services ?? []))
                        <li><a href="{{ route('dashboard.hosts.whatsapp') }}" class="nav-link">{{ __('whatsapp_accounts') }}</a></li>
                        @endif
                    </ul>
                </div>
            </li>
            
            <li class="nav-item">
                <a href="#toolsMenu" class="nav-link" data-bs-toggle="collapse">
                    <i class="bi bi-tools"></i>
                    <span>{{ __('tools') }}</span>
                    <i class="bi bi-chevron-down ms-auto"></i>
                </a>
                <div class="collapse" id="toolsMenu">
                    <ul class="nav flex-column ms-3">
                        @if(in_array('api', $services ?? []))
                        <li><a href="{{ route('dashboard.tools.keys') }}" class="nav-link">{{ __('api_keys') }}</a></li>
                        @endif
                        @if(in_array('webhooks', $services ?? []))
                        <li><a href="{{ route('dashboard.tools.webhooks') }}" class="nav-link">{{ __('webhooks') }}</a></li>
                        @endif
                        @if(in_array('actions', $services ?? []))
                        <li><a href="{{ route('dashboard.tools.actions') }}" class="nav-link">{{ __('actions') }}</a></li>
                        @endif
                        @if(in_array('templates', $services ?? []))
                        <li><a href="{{ route('dashboard.tools.templates') }}" class="nav-link">{{ __('templates') }}</a></li>
                        @endif
                        @if(in_array('flows', $services ?? []))
                        <li><a href="{{ route('dashboard.tools.flows') }}" class="nav-link">{{ __('flows') }}</a></li>
                        @endif
                        <li><a href="{{ route('dashboard.tools.staff') }}" class="nav-link">{{ __('staff') }}</a></li>
                        <li><a href="{{ route('dashboard.tools.logger') }}" class="nav-link">{{ __('logger') }}</a></li>
                    </ul>
                </div>
            </li>
            
            @if(in_array('ai', $services ?? []))
            <li class="nav-item">
                <a href="#aiMenu" class="nav-link" data-bs-toggle="collapse">
                    <i class="bi bi-robot"></i>
                    <span>{{ __('ai') }}</span>
                    <i class="bi bi-chevron-down ms-auto"></i>
                </a>
                <div class="collapse" id="aiMenu">
                    <ul class="nav flex-column ms-3">
                        <li><a href="{{ route('dashboard.ai.keys') }}" class="nav-link">{{ __('ai_keys') }}</a></li>
                        <li><a href="{{ route('dashboard.ai.plugins') }}" class="nav-link">{{ __('ai_plugins') }}</a></li>
                    </ul>
                </div>
            </li>
            @endif
            
            <li class="nav-item">
                <a href="{{ route('dashboard.reports.index') }}" class="nav-link {{ request()->routeIs('dashboard.reports.*') ? 'active' : '' }}">
                    <i class="bi bi-graph-up"></i>
                    <span>{{ __('reports') }}</span>
                </a>
            </li>
            
            <li class="nav-item">
                <a href="#docsMenu" class="nav-link" data-bs-toggle="collapse">
                    <i class="bi bi-book"></i>
                    <span>{{ __('documentation') }}</span>
                    <i class="bi bi-chevron-down ms-auto"></i>
                </a>
                <div class="collapse" id="docsMenu">
                    <ul class="nav flex-column ms-3">
                        <li><a href="{{ route('dashboard.docs.index') }}" class="nav-link">{{ __('api_docs') }}</a></li>
                        <li><a href="{{ route('dashboard.docs.webhooks') }}" class="nav-link">{{ __('webhooks_docs') }}</a></li>
                        <li><a href="{{ route('dashboard.docs.android') }}" class="nav-link">{{ __('android_docs') }}</a></li>
                    </ul>
                </div>
            </li>
            
            @if(auth()->user()->role == 1)
            <li class="nav-item mt-3">
                <small class="text-muted px-3">{{ __('administration') }}</small>
            </li>
            <li class="nav-item">
                <a href="{{ route('admin.dashboard') }}" class="nav-link">
                    <i class="bi bi-shield-lock"></i>
                    <span>{{ __('admin_panel') }}</span>
                </a>
            </li>
            @endif
        </ul>
    </nav>
</aside>
