@extends('layouts.app')
@section('title', __('AI Plugins'))
@section('page-title', __('AI Plugins'))
@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>{{ __('AI Plugins') }}</span>
        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addModal"><i class="bi bi-plus-lg me-1"></i>{{ __('Add Plugin') }}</button>
    </div>
    <div class="card-body">
        <div class="table-responsive"><table class="table table-hover"><thead><tr><th>{{ __('Name') }}</th><th>{{ __('Endpoint') }}</th><th>{{ __('Created') }}</th><th>{{ __('Actions') }}</th></tr></thead><tbody>
            @forelse($plugins as $p)
            <tr><td>{{ $p->name }}</td><td><small>{{ Str::limit($p->endpoint, 40) }}</small></td><td>{{ $p->create_date }}</td>
            <td><button class="btn btn-outline-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editModal{{ $p->id }}"><i class="bi bi-pencil"></i></button>
            <form action="{{ route('ai.plugins.destroy', $p) }}" method="POST" class="d-inline">@csrf @method('DELETE')<button type="submit" class="btn btn-outline-danger btn-sm"><i class="bi bi-trash"></i></button></form></td></tr>
            @empty<tr><td colspan="4" class="text-center text-muted py-4">{{ __('No plugins') }}</td></tr>@endforelse
        </tbody></table></div>{{ $plugins->links() }}
    </div>
</div>

<div class="modal fade" id="addModal" tabindex="-1"><div class="modal-dialog modal-lg"><div class="modal-content"><form method="POST" action="{{ route('ai.plugins.store') }}">@csrf
    <div class="modal-header"><h5 class="modal-title">{{ __('Add Plugin') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body"><div class="mb-3"><label class="form-label">{{ __('Name') }}</label><input type="text" name="name" class="form-control" required></div>
    <div class="mb-3"><label class="form-label">{{ __('Endpoint') }}</label><input type="url" name="endpoint" class="form-control" required></div>
    <div class="mb-3"><label class="form-label">{{ __('Schema (JSON)') }}</label><textarea name="schema" class="form-control" rows="6" required></textarea></div></div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Save') }}</button></div>
</form></div></div></div>
@foreach($plugins as $p)
<div class="modal fade" id="editModal{{ $p->id }}" tabindex="-1"><div class="modal-dialog modal-lg"><div class="modal-content"><form method="POST" action="{{ route('ai.plugins.update', $p) }}">@csrf @method('PUT')
    <div class="modal-header"><h5 class="modal-title">{{ __('Edit Plugin') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body"><div class="mb-3"><label class="form-label">{{ __('Name') }}</label><input type="text" name="name" class="form-control" value="{{ $p->name }}" required></div>
    <div class="mb-3"><label class="form-label">{{ __('Endpoint') }}</label><input type="url" name="endpoint" class="form-control" value="{{ $p->endpoint }}" required></div>
    <div class="mb-3"><label class="form-label">{{ __('Schema (JSON)') }}</label><textarea name="schema" class="form-control" rows="6" required>{{ $p->schema }}</textarea></div></div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Update') }}</button></div>
</form></div></div></div>
@endforeach
@endsection
