@extends('layouts.app')

@section('title', __('Edit Contact'))
@section('page-title', __('Edit Contact'))

@section('content')
<div class="card">
    <div class="card-header">{{ __('Edit Contact') }}</div>
    <div class="card-body">
        <form method="POST" action="{{ route('contacts.update', $contact) }}">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="name" class="form-label">{{ __('Name') }}</label>
                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                           id="name" name="name" value="{{ old('name', $contact->name) }}" required>
                    @error('name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label for="phone" class="form-label">{{ __('Phone Number') }}</label>
                    <input type="text" class="form-control @error('phone') is-invalid @enderror" 
                           id="phone" name="phone" value="{{ old('phone', $contact->phone) }}" required>
                    @error('phone')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="mb-3">
                <label class="form-label">{{ __('Groups') }}</label>
                <div class="row">
                    @php $contactGroups = explode(',', $contact->groups); @endphp
                    @foreach($groups as $group)
                    <div class="col-md-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="groups[]" 
                                   value="{{ $group->id }}" id="group{{ $group->id }}"
                                   {{ in_array($group->id, $contactGroups) ? 'checked' : '' }}>
                            <label class="form-check-label" for="group{{ $group->id }}">{{ $group->name }}</label>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary"><i class="bi bi-check me-2"></i>{{ __('Update') }}</button>
                <a href="{{ route('contacts.index') }}" class="btn btn-secondary">{{ __('Cancel') }}</a>
            </div>
        </form>
    </div>
</div>
@endsection
