@extends('layouts.app')

@section('title', __('Tags'))
@section('page-title', __('Contact Tags'))

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>{{ __('All Tags') }}</span>
        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addModal">
            <i class="bi bi-plus-lg me-1"></i>{{ __('Add Tag') }}
        </button>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>{{ __('Color') }}</th>
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('Created') }}</th>
                        <th>{{ __('Actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($tags as $tag)
                    <tr>
                        <td><span class="badge" style="background-color: {{ $tag->color }}">{{ $tag->color }}</span></td>
                        <td>{{ $tag->name }}</td>
                        <td>{{ $tag->created }}</td>
                        <td>
                            <button class="btn btn-outline-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editModal{{ $tag->id }}"><i class="bi bi-pencil"></i></button>
                            <form action="{{ route('tags.destroy', $tag) }}" method="POST" class="d-inline">@csrf @method('DELETE')
                                <button type="submit" class="btn btn-outline-danger btn-sm" onclick="return confirm('{{ __('Are you sure?') }}')"><i class="bi bi-trash"></i></button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr><td colspan="4" class="text-center text-muted py-4">{{ __('No tags found') }}</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        {{ $tags->links() }}
    </div>
</div>

<div class="modal fade" id="addModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="{{ route('tags.store') }}">
                @csrf
                <div class="modal-header"><h5 class="modal-title">{{ __('Add Tag') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
                <div class="modal-body">
                    <div class="mb-3"><label class="form-label">{{ __('Name') }}</label><input type="text" name="name" class="form-control" required></div>
                    <div class="mb-3"><label class="form-label">{{ __('Color') }}</label><input type="color" name="color" class="form-control form-control-color" value="#6c757d"></div>
                </div>
                <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Save') }}</button></div>
            </form>
        </div>
    </div>
</div>

@foreach($tags as $tag)
<div class="modal fade" id="editModal{{ $tag->id }}" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="{{ route('tags.update', $tag) }}">@csrf @method('PUT')
                <div class="modal-header"><h5 class="modal-title">{{ __('Edit Tag') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
                <div class="modal-body">
                    <div class="mb-3"><label class="form-label">{{ __('Name') }}</label><input type="text" name="name" class="form-control" value="{{ $tag->name }}" required></div>
                    <div class="mb-3"><label class="form-label">{{ __('Color') }}</label><input type="color" name="color" class="form-control form-control-color" value="{{ $tag->color }}"></div>
                </div>
                <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Update') }}</button></div>
            </form>
        </div>
    </div>
</div>
@endforeach
@endsection
