@extends('layouts.app')

@section('title', __('Unsubscribed'))
@section('page-title', __('Unsubscribed Numbers'))

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>{{ __('Unsubscribed') }}</span>
        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addModal"><i class="bi bi-plus-lg me-1"></i>{{ __('Add Number') }}</button>
    </div>
    <div class="card-body">
        <form method="GET" class="row g-3 mb-4">
            <div class="col-md-4"><input type="text" name="search" class="form-control" placeholder="{{ __('Search phone...') }}" value="{{ request('search') }}"></div>
            <div class="col-md-2"><button type="submit" class="btn btn-outline-primary">{{ __('Search') }}</button></div>
        </form>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead><tr><th>{{ __('Phone') }}</th><th>{{ __('Type') }}</th><th>{{ __('Date') }}</th><th>{{ __('Actions') }}</th></tr></thead>
                <tbody>
                    @forelse($unsubscribed as $item)
                    <tr>
                        <td>{{ $item->phone }}</td>
                        <td><span class="badge bg-{{ $item->type == 'sms' ? 'primary' : 'success' }}">{{ strtoupper($item->type) }}</span></td>
                        <td>{{ $item->create_date }}</td>
                        <td><form action="{{ route('unsubscribed.destroy', $item) }}" method="POST" class="d-inline">@csrf @method('DELETE')<button type="submit" class="btn btn-outline-danger btn-sm" onclick="return confirm('{{ __('Are you sure?') }}')"><i class="bi bi-trash"></i></button></form></td>
                    </tr>
                    @empty
                    <tr><td colspan="4" class="text-center text-muted py-4">{{ __('No unsubscribed numbers') }}</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        {{ $unsubscribed->links() }}
    </div>
</div>

<div class="modal fade" id="addModal" tabindex="-1"><div class="modal-dialog"><div class="modal-content"><form method="POST" action="{{ route('unsubscribed.store') }}">@csrf
    <div class="modal-header"><h5 class="modal-title">{{ __('Add Number') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body">
        <div class="mb-3"><label class="form-label">{{ __('Phone') }}</label><input type="text" name="phone" class="form-control" placeholder="+971..." required></div>
        <div class="mb-3"><label class="form-label">{{ __('Type') }}</label><select name="type" class="form-control"><option value="sms">SMS</option><option value="whatsapp">WhatsApp</option></select></div>
    </div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Add') }}</button></div>
</form></div></div></div>
@endsection
