@extends('layouts.app')
@section('title', __('Android Devices'))
@section('page-title', __('Android Devices'))
@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>{{ __('Devices') }}</span>
        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addModal"><i class="bi bi-plus-lg me-1"></i>{{ __('Add Device') }}</button>
    </div>
    <div class="card-body">
        <div class="table-responsive"><table class="table table-hover"><thead><tr><th>{{ __('Name') }}</th><th>{{ __('Device ID') }}</th><th>{{ __('Manufacturer') }}</th><th>{{ __('Status') }}</th><th>{{ __('Created') }}</th><th>{{ __('Actions') }}</th></tr></thead><tbody>
            @forelse($devices as $d)
            <tr><td>{{ $d->name }}</td><td><small class="text-muted">{{ Str::limit($d->did, 20) }}</small></td><td>{{ $d->manufacturer ?? '-' }}</td>
            <td>@if($d->online_id)<span class="badge bg-success">{{ __('Online') }}</span>@else<span class="badge bg-secondary">{{ __('Offline') }}</span>@endif</td>
            <td>{{ $d->create_date }}</td>
            <td><button class="btn btn-outline-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editModal{{ $d->id }}"><i class="bi bi-pencil"></i></button>
            <form action="{{ route('hosts.android.destroy', $d) }}" method="POST" class="d-inline">@csrf @method('DELETE')<button type="submit" class="btn btn-outline-danger btn-sm"><i class="bi bi-trash"></i></button></form></td></tr>
            @empty<tr><td colspan="6" class="text-center text-muted py-4">{{ __('No devices') }}</td></tr>@endforelse
        </tbody></table></div>{{ $devices->links() }}
    </div>
</div>

<div class="modal fade" id="addModal" tabindex="-1"><div class="modal-dialog"><div class="modal-content"><form method="POST" action="{{ route('hosts.android.store') }}">@csrf
    <div class="modal-header"><h5 class="modal-title">{{ __('Add Device') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body"><div class="mb-3"><label class="form-label">{{ __('Name') }}</label><input type="text" name="name" class="form-control" required></div>
    <div class="mb-3"><label class="form-label">{{ __('Manufacturer') }}</label><input type="text" name="manufacturer" class="form-control"></div></div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Save') }}</button></div>
</form></div></div></div>
@foreach($devices as $d)
<div class="modal fade" id="editModal{{ $d->id }}" tabindex="-1"><div class="modal-dialog"><div class="modal-content"><form method="POST" action="{{ route('hosts.android.update', $d) }}">@csrf @method('PUT')
    <div class="modal-header"><h5 class="modal-title">{{ __('Edit Device') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body"><div class="mb-3"><label class="form-label">{{ __('Name') }}</label><input type="text" name="name" class="form-control" value="{{ $d->name }}" required></div>
    <div class="mb-3"><label class="form-label">{{ __('Manufacturer') }}</label><input type="text" name="manufacturer" class="form-control" value="{{ $d->manufacturer }}"></div></div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Update') }}</button></div>
</form></div></div></div>
@endforeach
@endsection
