@extends('layouts.app')
@section('title', __('USSD'))
@section('page-title', __('USSD Codes'))
@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>{{ __('USSD History') }}</span>
        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addModal"><i class="bi bi-plus-lg me-1"></i>{{ __('Send USSD') }}</button>
    </div>
    <div class="card-body">
        <div class="table-responsive"><table class="table table-hover"><thead><tr><th>{{ __('Code') }}</th><th>{{ __('Response') }}</th><th>{{ __('Device') }}</th><th>{{ __('Status') }}</th><th>{{ __('Date') }}</th><th>{{ __('Actions') }}</th></tr></thead><tbody>
            @forelse($ussd as $u)
            <tr><td><code>{{ $u->code }}</code></td><td>{{ Str::limit($u->response, 40) }}</td><td>{{ $u->did }}</td>
            <td>@if($u->status == 1)<span class="badge bg-warning">{{ __('Pending') }}</span>@elseif($u->status == 2)<span class="badge bg-success">{{ __('Success') }}</span>@else<span class="badge bg-danger">{{ __('Failed') }}</span>@endif</td>
            <td>{{ $u->create_date }}</td>
            <td><form action="{{ route('hosts.ussd.destroy', $u) }}" method="POST" class="d-inline">@csrf @method('DELETE')<button type="submit" class="btn btn-outline-danger btn-sm"><i class="bi bi-trash"></i></button></form></td></tr>
            @empty<tr><td colspan="6" class="text-center text-muted py-4">{{ __('No USSD history') }}</td></tr>@endforelse
        </tbody></table></div>{{ $ussd->links() }}
    </div>
</div>

<div class="modal fade" id="addModal" tabindex="-1"><div class="modal-dialog"><div class="modal-content"><form method="POST" action="{{ route('hosts.ussd.store') }}">@csrf
    <div class="modal-header"><h5 class="modal-title">{{ __('Send USSD') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body">
        <div class="mb-3"><label class="form-label">{{ __('Device') }}</label><select name="did" class="form-control" required>@foreach($devices as $d)<option value="{{ $d->did }}">{{ $d->name }}</option>@endforeach</select></div>
        <div class="mb-3"><label class="form-label">{{ __('SIM') }}</label><select name="sim" class="form-control"><option value="0">SIM 1</option><option value="1">SIM 2</option></select></div>
        <div class="mb-3"><label class="form-label">{{ __('USSD Code') }}</label><input type="text" name="code" class="form-control" placeholder="*123#" required></div>
    </div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Send') }}</button></div>
</form></div></div></div>
@endsection
