@extends('layouts.app')

@section('title', __('profile'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-4">
            <div class="card">
                <div class="card-body text-center">
                    <img src="{{ $user->avatar ?? asset('images/default-avatar.png') }}" class="rounded-circle mb-3" width="120" height="120">
                    <h5>{{ $user->name }}</h5>
                    <p class="text-muted">{{ $user->email }}</p>
                    @if($user->subscription)
                    <span class="badge bg-success">{{ $user->subscription->package->name ?? 'N/A' }}</span>
                    @else
                    <span class="badge bg-secondary">{{ __('no_subscription') }}</span>
                    @endif
                </div>
            </div>
            
            <div class="card mt-3">
                <div class="card-header">
                    <h6 class="mb-0">{{ __('account_info') }}</h6>
                </div>
                <div class="card-body">
                    <p><strong>{{ __('credits') }}:</strong> {{ number_format($user->credits, 2) }}</p>
                    <p><strong>{{ __('member_since') }}:</strong> {{ $user->created_at->format('Y-m-d') }}</p>
                    <p><strong>{{ __('timezone') }}:</strong> {{ $user->timezone ?? 'UTC' }}</p>
                </div>
            </div>
        </div>
        
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <ul class="nav nav-tabs card-header-tabs">
                        <li class="nav-item">
                            <a class="nav-link active" data-bs-toggle="tab" href="#profileTab">{{ __('profile') }}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#securityTab">{{ __('security') }}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#preferencesTab">{{ __('preferences') }}</a>
                        </li>
                    </ul>
                </div>
                <div class="card-body">
                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="profileTab">
                            <form action="{{ route('profile.update') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('name') }}</label>
                                        <input type="text" name="name" class="form-control" value="{{ $user->name }}" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('email') }}</label>
                                        <input type="email" name="email" class="form-control" value="{{ $user->email }}" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('phone') }}</label>
                                        <input type="text" name="phone" class="form-control" value="{{ $user->phone }}">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('avatar') }}</label>
                                        <input type="file" name="avatar" class="form-control" accept="image/*">
                                    </div>
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary">{{ __('save_changes') }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        
                        <div class="tab-pane fade" id="securityTab">
                            <form action="{{ route('profile.password') }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-12 mb-3">
                                        <label class="form-label">{{ __('current_password') }}</label>
                                        <input type="password" name="current_password" class="form-control" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('new_password') }}</label>
                                        <input type="password" name="password" class="form-control" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('confirm_password') }}</label>
                                        <input type="password" name="password_confirmation" class="form-control" required>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary">{{ __('change_password') }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        
                        <div class="tab-pane fade" id="preferencesTab">
                            <form action="{{ route('profile.update') }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('language') }}</label>
                                        <select name="language" class="form-control">
                                            @foreach($languages ?? [] as $lang)
                                            <option value="{{ $lang->id }}" {{ $user->language == $lang->id ? 'selected' : '' }}>{{ $lang->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">{{ __('timezone') }}</label>
                                        <select name="timezone" class="form-control">
                                            @foreach(timezone_identifiers_list() as $tz)
                                            <option value="{{ $tz }}" {{ $user->timezone == $tz ? 'selected' : '' }}>{{ $tz }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-12 mb-3">
                                        <div class="form-check">
                                            <input type="checkbox" name="alertsound" class="form-check-input" value="1" {{ $user->alertsound ? 'checked' : '' }}>
                                            <label class="form-check-label">{{ __('notification_sounds') }}</label>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary">{{ __('save_preferences') }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
