@extends('layouts.app')
@section('title', __('SMS Queue'))
@section('page-title', __('SMS Queue'))
@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>{{ __('Pending Messages') }}</span>
        <form action="{{ route('sms.queue.clear') }}" method="POST" class="d-inline">@csrf<button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('{{ __('Clear all pending messages?') }}')"><i class="bi bi-trash me-1"></i>{{ __('Clear Queue') }}</button></form>
    </div>
    <div class="card-body">
        <div class="table-responsive"><table class="table table-hover"><thead><tr><th>{{ __('To') }}</th><th>{{ __('Message') }}</th><th>{{ __('Device') }}</th><th>{{ __('Date') }}</th></tr></thead><tbody>
            @forelse($messages as $msg)
            <tr><td>{{ $msg->phone }}</td><td>{{ Str::limit($msg->message, 50) }}</td><td>{{ $msg->did }}</td><td>{{ $msg->create_date }}</td></tr>
            @empty<tr><td colspan="4" class="text-center text-muted py-4">{{ __('Queue is empty') }}</td></tr>@endforelse
        </tbody></table></div>{{ $messages->links() }}
    </div>
</div>
@endsection
