@extends('layouts.app')
@section('title', __('API Keys'))
@section('page-title', __('API Keys'))
@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>{{ __('API Keys') }}</span>
        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addModal"><i class="bi bi-plus-lg me-1"></i>{{ __('Add Key') }}</button>
    </div>
    <div class="card-body">
        <div class="table-responsive"><table class="table table-hover"><thead><tr><th>{{ __('Name') }}</th><th>{{ __('Secret') }}</th><th>{{ __('Created') }}</th><th>{{ __('Actions') }}</th></tr></thead><tbody>
            @forelse($keys as $k)
            <tr><td>{{ $k->name }}</td><td><code>{{ substr($k->secret, 0, 20) }}...</code><button class="btn btn-sm btn-link" onclick="navigator.clipboard.writeText('{{ $k->secret }}')"><i class="bi bi-clipboard"></i></button></td><td>{{ $k->create_date }}</td>
            <td>
                <form action="{{ route('tools.keys.regenerate', $k) }}" method="POST" class="d-inline">@csrf<button type="submit" class="btn btn-outline-warning btn-sm" onclick="return confirm('{{ __('Regenerate key?') }}')"><i class="bi bi-arrow-repeat"></i></button></form>
                <form action="{{ route('tools.keys.destroy', $k) }}" method="POST" class="d-inline">@csrf @method('DELETE')<button type="submit" class="btn btn-outline-danger btn-sm"><i class="bi bi-trash"></i></button></form>
            </td></tr>
            @empty<tr><td colspan="4" class="text-center text-muted py-4">{{ __('No API keys') }}</td></tr>@endforelse
        </tbody></table></div>{{ $keys->links() }}
    </div>
</div>

<div class="modal fade" id="addModal" tabindex="-1"><div class="modal-dialog"><div class="modal-content"><form method="POST" action="{{ route('tools.keys.store') }}">@csrf
    <div class="modal-header"><h5 class="modal-title">{{ __('Add API Key') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body"><div class="mb-3"><label class="form-label">{{ __('Name') }}</label><input type="text" name="name" class="form-control" required></div>
    <div class="mb-3"><label class="form-label">{{ __('Permissions') }}</label>
        <div class="form-check"><input class="form-check-input" type="checkbox" name="permissions[]" value="send_sms" id="p1"><label class="form-check-label" for="p1">{{ __('Send SMS') }}</label></div>
        <div class="form-check"><input class="form-check-input" type="checkbox" name="permissions[]" value="send_whatsapp" id="p2"><label class="form-check-label" for="p2">{{ __('Send WhatsApp') }}</label></div>
        <div class="form-check"><input class="form-check-input" type="checkbox" name="permissions[]" value="manage_contacts" id="p3"><label class="form-check-label" for="p3">{{ __('Manage Contacts') }}</label></div>
    </div></div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Create') }}</button></div>
</form></div></div></div>
@endsection
