@extends('layouts.app')
@section('title', __('Templates'))
@section('page-title', __('Message Templates'))
@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>{{ __('Templates') }}</span>
        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addModal"><i class="bi bi-plus-lg me-1"></i>{{ __('Add Template') }}</button>
    </div>
    <div class="card-body">
        <form method="GET" class="row g-3 mb-4"><div class="col-md-3"><select name="category" class="form-control"><option value="">{{ __('All Categories') }}</option>@foreach($categories as $c)<option value="{{ $c->id }}" @if(request('category')==$c->id)selected @endif>{{ $c->name }}</option>@endforeach</select></div><div class="col-md-2"><button type="submit" class="btn btn-outline-primary">{{ __('Filter') }}</button></div></form>
        <div class="table-responsive"><table class="table table-hover"><thead><tr><th>{{ __('Name') }}</th><th>{{ __('Category') }}</th><th>{{ __('Preview') }}</th><th>{{ __('Actions') }}</th></tr></thead><tbody>
            @forelse($templates as $t)
            <tr><td>{{ $t->name }}</td><td>{{ $t->category->name ?? '-' }}</td><td>{{ Str::limit($t->format, 50) }}</td>
            <td><button class="btn btn-outline-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editModal{{ $t->id }}"><i class="bi bi-pencil"></i></button>
            <form action="{{ route('tools.templates.destroy', $t) }}" method="POST" class="d-inline">@csrf @method('DELETE')<button type="submit" class="btn btn-outline-danger btn-sm"><i class="bi bi-trash"></i></button></form></td></tr>
            @empty<tr><td colspan="4" class="text-center text-muted py-4">{{ __('No templates') }}</td></tr>@endforelse
        </tbody></table></div>{{ $templates->links() }}
    </div>
</div>

<div class="modal fade" id="addModal" tabindex="-1"><div class="modal-dialog modal-lg"><div class="modal-content"><form method="POST" action="{{ route('tools.templates.store') }}">@csrf
    <div class="modal-header"><h5 class="modal-title">{{ __('Add Template') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body"><div class="row"><div class="col-md-6 mb-3"><label class="form-label">{{ __('Name') }}</label><input type="text" name="name" class="form-control" required></div>
    <div class="col-md-6 mb-3"><label class="form-label">{{ __('Category') }}</label><select name="category_id" class="form-control"><option value="0">{{ __('None') }}</option>@foreach($categories as $c)<option value="{{ $c->id }}">{{ $c->name }}</option>@endforeach</select></div></div>
    <div class="mb-3"><label class="form-label">{{ __('Content') }}</label><textarea name="format" class="form-control" rows="6" required></textarea><small class="text-muted">{{ __('Variables: {name}, {phone}, {date}') }}</small></div></div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Save') }}</button></div>
</form></div></div></div>
@foreach($templates as $t)
<div class="modal fade" id="editModal{{ $t->id }}" tabindex="-1"><div class="modal-dialog modal-lg"><div class="modal-content"><form method="POST" action="{{ route('tools.templates.update', $t) }}">@csrf @method('PUT')
    <div class="modal-header"><h5 class="modal-title">{{ __('Edit Template') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body"><div class="row"><div class="col-md-6 mb-3"><label class="form-label">{{ __('Name') }}</label><input type="text" name="name" class="form-control" value="{{ $t->name }}" required></div>
    <div class="col-md-6 mb-3"><label class="form-label">{{ __('Category') }}</label><select name="category_id" class="form-control"><option value="0">{{ __('None') }}</option>@foreach($categories as $c)<option value="{{ $c->id }}" @if($t->category_id==$c->id)selected @endif>{{ $c->name }}</option>@endforeach</select></div></div>
    <div class="mb-3"><label class="form-label">{{ __('Content') }}</label><textarea name="format" class="form-control" rows="6" required>{{ $t->format }}</textarea></div></div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Update') }}</button></div>
</form></div></div></div>
@endforeach
@endsection
