@extends('layouts.app')
@section('title', __('Webhooks'))
@section('page-title', __('Webhooks'))
@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>{{ __('Webhooks') }}</span>
        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addModal"><i class="bi bi-plus-lg me-1"></i>{{ __('Add Webhook') }}</button>
    </div>
    <div class="card-body">
        <div class="table-responsive"><table class="table table-hover"><thead><tr><th>{{ __('Name') }}</th><th>{{ __('URL') }}</th><th>{{ __('Events') }}</th><th>{{ __('Created') }}</th><th>{{ __('Actions') }}</th></tr></thead><tbody>
            @forelse($webhooks as $w)
            <tr><td>{{ $w->name }}</td><td><small>{{ Str::limit($w->url, 40) }}</small></td><td>@php $events = json_decode($w->events, true) ?? []; @endphp {{ count($events) }} {{ __('events') }}</td><td>{{ $w->create_date }}</td>
            <td><button class="btn btn-outline-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editModal{{ $w->id }}"><i class="bi bi-pencil"></i></button>
            <form action="{{ route('tools.webhooks.destroy', $w) }}" method="POST" class="d-inline">@csrf @method('DELETE')<button type="submit" class="btn btn-outline-danger btn-sm"><i class="bi bi-trash"></i></button></form></td></tr>
            @empty<tr><td colspan="5" class="text-center text-muted py-4">{{ __('No webhooks') }}</td></tr>@endforelse
        </tbody></table></div>{{ $webhooks->links() }}
    </div>
</div>

<div class="modal fade" id="addModal" tabindex="-1"><div class="modal-dialog"><div class="modal-content"><form method="POST" action="{{ route('tools.webhooks.store') }}">@csrf
    <div class="modal-header"><h5 class="modal-title">{{ __('Add Webhook') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body"><div class="mb-3"><label class="form-label">{{ __('Name') }}</label><input type="text" name="name" class="form-control" required></div>
    <div class="mb-3"><label class="form-label">{{ __('URL') }}</label><input type="url" name="url" class="form-control" placeholder="https://..." required></div>
    <div class="mb-3"><label class="form-label">{{ __('Events') }}</label>
        <div class="form-check"><input class="form-check-input" type="checkbox" name="events[]" value="message.received">{{ __('Message Received') }}</div>
        <div class="form-check"><input class="form-check-input" type="checkbox" name="events[]" value="message.sent">{{ __('Message Sent') }}</div>
        <div class="form-check"><input class="form-check-input" type="checkbox" name="events[]" value="message.failed">{{ __('Message Failed') }}</div>
    </div></div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Create') }}</button></div>
</form></div></div></div>
@foreach($webhooks as $w)
<div class="modal fade" id="editModal{{ $w->id }}" tabindex="-1"><div class="modal-dialog"><div class="modal-content"><form method="POST" action="{{ route('tools.webhooks.update', $w) }}">@csrf @method('PUT')
    <div class="modal-header"><h5 class="modal-title">{{ __('Edit Webhook') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body"><div class="mb-3"><label class="form-label">{{ __('Name') }}</label><input type="text" name="name" class="form-control" value="{{ $w->name }}" required></div>
    <div class="mb-3"><label class="form-label">{{ __('URL') }}</label><input type="url" name="url" class="form-control" value="{{ $w->url }}" required></div></div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-primary">{{ __('Update') }}</button></div>
</form></div></div></div>
@endforeach
@endsection
