@extends('layouts.app')

@section('title', __('WhatsApp Accounts'))
@section('page-title', __('WhatsApp Accounts'))

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>{{ __('Connected Accounts') }}</span>
        <a href="{{ route('whatsapp.accounts.create') }}" class="btn btn-primary btn-sm">
            <i class="bi bi-plus-lg me-1"></i>{{ __('Add Account') }}
        </a>
    </div>
    <div class="card-body">
        @if($accounts->isEmpty())
        <div class="text-center py-5">
            <i class="bi bi-whatsapp text-muted" style="font-size: 4rem;"></i>
            <h5 class="mt-3">{{ __('No WhatsApp accounts connected') }}</h5>
            <p class="text-muted">{{ __('Connect your first WhatsApp account to start sending messages.') }}</p>
            <a href="{{ route('whatsapp.accounts.create') }}" class="btn btn-success">
                <i class="bi bi-qr-code me-2"></i>{{ __('Scan QR Code') }}
            </a>
        </div>
        @else
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>{{ __('Phone Number') }}</th>
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Created') }}</th>
                        <th>{{ __('Actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($accounts as $account)
                    <tr>
                        <td>{{ $account->phone ?? '-' }}</td>
                        <td>{{ $account->name ?? '-' }}</td>
                        <td>
                            @if($account->status == 1)
                            <span class="badge-status badge-success">
                                <i class="bi bi-check-circle me-1"></i>{{ __('Connected') }}
                            </span>
                            @else
                            <span class="badge-status badge-warning">
                                <i class="bi bi-exclamation-circle me-1"></i>{{ __('Disconnected') }}
                            </span>
                            @endif
                        </td>
                        <td>{{ $account->create_date }}</td>
                        <td>
                            <form action="{{ route('whatsapp.accounts.delete', $account) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-outline-danger btn-sm" onclick="return confirm('{{ __('Are you sure?') }}')">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @endif
    </div>
</div>
@endsection
