@extends('layouts.app')
@section('title', __('WhatsApp Campaigns'))
@section('page-title', __('WhatsApp Campaigns'))
@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>{{ __('Campaigns') }}</span>
        <button class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#addModal"><i class="bi bi-plus-lg me-1"></i>{{ __('New Campaign') }}</button>
    </div>
    <div class="card-body">
        <div class="table-responsive"><table class="table table-hover"><thead><tr><th>{{ __('Name') }}</th><th>{{ __('Total') }}</th><th>{{ __('Sent') }}</th><th>{{ __('Failed') }}</th><th>{{ __('Status') }}</th><th>{{ __('Actions') }}</th></tr></thead><tbody>
            @forelse($campaigns as $c)
            <tr><td>{{ $c->name }}</td><td>{{ $c->total }}</td><td><span class="text-success">{{ $c->sent }}</span></td><td><span class="text-danger">{{ $c->failed }}</span></td>
            <td>@if($c->status == 1)<span class="badge bg-warning">{{ __('Pending') }}</span>@elseif($c->status == 2)<span class="badge bg-info">{{ __('Running') }}</span>@elseif($c->status == 3)<span class="badge bg-secondary">{{ __('Stopped') }}</span>@else<span class="badge bg-success">{{ __('Completed') }}</span>@endif</td>
            <td>
                @if($c->status == 1 || $c->status == 3)<form action="{{ route('whatsapp.campaigns.start', $c) }}" method="POST" class="d-inline">@csrf<button type="submit" class="btn btn-outline-success btn-sm"><i class="bi bi-play"></i></button></form>@endif
                @if($c->status == 2)<form action="{{ route('whatsapp.campaigns.stop', $c) }}" method="POST" class="d-inline">@csrf<button type="submit" class="btn btn-outline-warning btn-sm"><i class="bi bi-pause"></i></button></form>@endif
                <form action="{{ route('whatsapp.campaigns.destroy', $c) }}" method="POST" class="d-inline">@csrf @method('DELETE')<button type="submit" class="btn btn-outline-danger btn-sm"><i class="bi bi-trash"></i></button></form>
            </td></tr>
            @empty<tr><td colspan="6" class="text-center text-muted py-4">{{ __('No campaigns') }}</td></tr>@endforelse
        </tbody></table></div>{{ $campaigns->links() }}
    </div>
</div>

<div class="modal fade" id="addModal" tabindex="-1"><div class="modal-dialog"><div class="modal-content"><form method="POST" action="{{ route('whatsapp.campaigns.store') }}">@csrf
    <div class="modal-header"><h5 class="modal-title">{{ __('New Campaign') }}</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body"><div class="mb-3"><label class="form-label">{{ __('Campaign Name') }}</label><input type="text" name="name" class="form-control" required></div><div class="mb-3"><label class="form-label">{{ __('Account') }}</label><select name="unique" class="form-control" required>@foreach($accounts as $a)<option value="{{ $a->unique }}">{{ $a->phone ?? $a->unique }}</option>@endforeach</select></div></div>
    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button><button type="submit" class="btn btn-success">{{ __('Create') }}</button></div>
</form></div></div></div>
@endsection
