@extends('layouts.app')

@section('title', __('and_dash_pg_doc_line40'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-3">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">{{ __('actions_documentation') }}</h6>
                </div>
                <div class="list-group list-group-flush">
                    <a href="#overview" class="list-group-item list-group-item-action">{{ __('overview') }}</a>
                    <a href="#create" class="list-group-item list-group-item-action">{{ __('create_action') }}</a>
                    <a href="#types" class="list-group-item list-group-item-action">{{ __('action_types') }}</a>
                    <a href="#variables" class="list-group-item list-group-item-action">{{ __('variables') }}</a>
                    <a href="#examples" class="list-group-item list-group-item-action">{{ __('examples') }}</a>
                </div>
            </div>
        </div>
        <div class="col-md-9">
            <div class="card">
                <div class="card-body">
                    <section id="overview" class="mb-5">
                        <h3>{{ __('overview') }}</h3>
                        <p>{{ __('actions_overview_text') }}</p>
                    </section>
                    
                    <section id="create" class="mb-5">
                        <h3>{{ __('create_action') }}</h3>
                        <ol>
                            <li>{{ __('action_step1') }}</li>
                            <li>{{ __('action_step2') }}</li>
                            <li>{{ __('action_step3') }}</li>
                            <li>{{ __('action_step4') }}</li>
                        </ol>
                    </section>
                    
                    <section id="types" class="mb-5">
                        <h3>{{ __('action_types') }}</h3>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <div class="card h-100">
                                    <div class="card-body">
                                        <h5><i class="bi bi-reply"></i> {{ __('auto_reply') }}</h5>
                                        <p>{{ __('auto_reply_desc') }}</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="card h-100">
                                    <div class="card-body">
                                        <h5><i class="bi bi-forward"></i> {{ __('forward_message') }}</h5>
                                        <p>{{ __('forward_message_desc') }}</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="card h-100">
                                    <div class="card-body">
                                        <h5><i class="bi bi-globe"></i> {{ __('webhook_call') }}</h5>
                                        <p>{{ __('webhook_call_desc') }}</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="card h-100">
                                    <div class="card-body">
                                        <h5><i class="bi bi-person-plus"></i> {{ __('add_to_group') }}</h5>
                                        <p>{{ __('add_to_group_desc') }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                    
                    <section id="variables" class="mb-5">
                        <h3>{{ __('variables') }}</h3>
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>{{ __('variable') }}</th>
                                    <th>{{ __('description') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr><td><code>{phone}</code></td><td>{{ __('var_phone') }}</td></tr>
                                <tr><td><code>{message}</code></td><td>{{ __('var_message') }}</td></tr>
                                <tr><td><code>{name}</code></td><td>{{ __('var_name') }}</td></tr>
                                <tr><td><code>{date}</code></td><td>{{ __('var_date') }}</td></tr>
                                <tr><td><code>{time}</code></td><td>{{ __('var_time') }}</td></tr>
                                <tr><td><code>{device}</code></td><td>{{ __('var_device') }}</td></tr>
                            </tbody>
                        </table>
                    </section>
                    
                    <section id="examples" class="mb-5">
                        <h3>{{ __('examples') }}</h3>
                        <div class="alert alert-secondary">
                            <strong>{{ __('example_welcome') }}:</strong><br>
                            {{ __('trigger') }}: {{ __('contains') }} "hello"<br>
                            {{ __('response') }}: "Hello {name}! Welcome to our service. How can I help you today?"
                        </div>
                    </section>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
