@extends('layouts.app')

@section('title', __('dashboard_docsnew_androidtitle'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-3">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">{{ __('android_documentation') }}</h6>
                </div>
                <div class="list-group list-group-flush">
                    <a href="#overview" class="list-group-item list-group-item-action">{{ __('overview') }}</a>
                    <a href="#requirements" class="list-group-item list-group-item-action">{{ __('requirements') }}</a>
                    <a href="#installation" class="list-group-item list-group-item-action">{{ __('installation') }}</a>
                    <a href="#setup" class="list-group-item list-group-item-action">{{ __('setup') }}</a>
                    <a href="#permissions" class="list-group-item list-group-item-action">{{ __('permissions') }}</a>
                    <a href="#troubleshooting" class="list-group-item list-group-item-action">{{ __('troubleshooting') }}</a>
                </div>
            </div>
        </div>
        <div class="col-md-9">
            <div class="card">
                <div class="card-body">
                    <section id="overview" class="mb-5">
                        <h3>{{ __('overview') }}</h3>
                        <p>{{ __('android_overview_text') }}</p>
                    </section>
                    
                    <section id="requirements" class="mb-5">
                        <h3>{{ __('requirements') }}</h3>
                        <ul>
                            <li>Android 5.0 (Lollipop) {{ __('or_higher') }}</li>
                            <li>{{ __('active_sim_card') }}</li>
                            <li>{{ __('stable_internet') }}</li>
                            <li>{{ __('battery_optimization_disabled') }}</li>
                        </ul>
                    </section>
                    
                    <section id="installation" class="mb-5">
                        <h3>{{ __('installation') }}</h3>
                        <ol>
                            <li>{{ __('android_install_step1') }}</li>
                            <li>{{ __('android_install_step2') }}</li>
                            <li>{{ __('android_install_step3') }}</li>
                            <li>{{ __('android_install_step4') }}</li>
                        </ol>
                        <a href="{{ route('dashboard.android.download') }}" class="btn btn-success">
                            <i class="bi bi-download"></i> {{ __('download_app') }}
                        </a>
                    </section>
                    
                    <section id="setup" class="mb-5">
                        <h3>{{ __('setup') }}</h3>
                        <ol>
                            <li>{{ __('android_setup_step1') }}</li>
                            <li>{{ __('android_setup_step2') }}</li>
                            <li>{{ __('android_setup_step3') }}</li>
                            <li>{{ __('android_setup_step4') }}</li>
                        </ol>
                        <div class="alert alert-info">
                            <strong>{{ __('server_url') }}:</strong> <code>{{ url('/') }}</code>
                        </div>
                    </section>
                    
                    <section id="permissions" class="mb-5">
                        <h3>{{ __('permissions') }}</h3>
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>{{ __('permission') }}</th>
                                    <th>{{ __('reason') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr><td>SEND_SMS</td><td>{{ __('perm_send_sms') }}</td></tr>
                                <tr><td>READ_SMS</td><td>{{ __('perm_read_sms') }}</td></tr>
                                <tr><td>RECEIVE_SMS</td><td>{{ __('perm_receive_sms') }}</td></tr>
                                <tr><td>READ_CONTACTS</td><td>{{ __('perm_read_contacts') }}</td></tr>
                                <tr><td>READ_PHONE_STATE</td><td>{{ __('perm_phone_state') }}</td></tr>
                            </tbody>
                        </table>
                    </section>
                    
                    <section id="troubleshooting" class="mb-5">
                        <h3>{{ __('troubleshooting') }}</h3>
                        <div class="accordion" id="troubleshootingAccordion">
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#trouble1">
                                        {{ __('trouble_not_connecting') }}
                                    </button>
                                </h2>
                                <div id="trouble1" class="accordion-collapse collapse">
                                    <div class="accordion-body">{{ __('trouble_not_connecting_solution') }}</div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#trouble2">
                                        {{ __('trouble_sms_not_sending') }}
                                    </button>
                                </h2>
                                <div id="trouble2" class="accordion-collapse collapse">
                                    <div class="accordion-body">{{ __('trouble_sms_not_sending_solution') }}</div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#trouble3">
                                        {{ __('trouble_app_killed') }}
                                    </button>
                                </h2>
                                <div id="trouble3" class="accordion-collapse collapse">
                                    <div class="accordion-body">{{ __('trouble_app_killed_solution') }}</div>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
