@extends('layouts.app')

@section('title', __('and_dash_pg_doc_line28'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-3">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">{{ __('api_documentation') }}</h6>
                </div>
                <div class="list-group list-group-flush">
                    <a href="#introduction" class="list-group-item list-group-item-action">{{ __('introduction') }}</a>
                    <a href="#authentication" class="list-group-item list-group-item-action">{{ __('authentication') }}</a>
                    <a href="#send-sms" class="list-group-item list-group-item-action">{{ __('send_sms') }}</a>
                    <a href="#send-whatsapp" class="list-group-item list-group-item-action">{{ __('send_whatsapp') }}</a>
                    <a href="#contacts" class="list-group-item list-group-item-action">{{ __('contacts') }}</a>
                    <a href="#messages" class="list-group-item list-group-item-action">{{ __('messages') }}</a>
                    <a href="#devices" class="list-group-item list-group-item-action">{{ __('devices') }}</a>
                    <a href="#errors" class="list-group-item list-group-item-action">{{ __('error_codes') }}</a>
                </div>
            </div>
        </div>
        <div class="col-md-9">
            <div class="card">
                <div class="card-body">
                    <section id="introduction" class="mb-5">
                        <h3>{{ __('introduction') }}</h3>
                        <p>{{ __('api_intro_text') }}</p>
                        <div class="alert alert-info">
                            <strong>Base URL:</strong> <code>{{ url('/api/v1') }}</code>
                        </div>
                    </section>
                    
                    <section id="authentication" class="mb-5">
                        <h3>{{ __('authentication') }}</h3>
                        <p>{{ __('api_auth_text') }}</p>
                        <div class="bg-dark text-light p-3 rounded">
                            <pre class="mb-0 text-light"><code>Authorization: Bearer YOUR_API_KEY</code></pre>
                        </div>
                    </section>
                    
                    <section id="send-sms" class="mb-5">
                        <h3>{{ __('send_sms') }}</h3>
                        <p><span class="badge bg-success">POST</span> <code>/api/v1/sms/send</code></p>
                        <h6>{{ __('parameters') }}:</h6>
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>{{ __('parameter') }}</th>
                                    <th>{{ __('type') }}</th>
                                    <th>{{ __('required') }}</th>
                                    <th>{{ __('description') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><code>phone</code></td>
                                    <td>string</td>
                                    <td>{{ __('yes') }}</td>
                                    <td>{{ __('phone_number_with_country_code') }}</td>
                                </tr>
                                <tr>
                                    <td><code>message</code></td>
                                    <td>string</td>
                                    <td>{{ __('yes') }}</td>
                                    <td>{{ __('message_content') }}</td>
                                </tr>
                                <tr>
                                    <td><code>device</code></td>
                                    <td>integer</td>
                                    <td>{{ __('no') }}</td>
                                    <td>{{ __('device_id') }}</td>
                                </tr>
                            </tbody>
                        </table>
                        <h6>{{ __('example_request') }}:</h6>
                        <div class="bg-dark text-light p-3 rounded">
                            <pre class="mb-0 text-light"><code>curl -X POST "{{ url('/api/v1/sms/send') }}" \
  -H "Authorization: Bearer YOUR_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{"phone": "+1234567890", "message": "Hello World"}'</code></pre>
                        </div>
                    </section>
                    
                    <section id="send-whatsapp" class="mb-5">
                        <h3>{{ __('send_whatsapp') }}</h3>
                        <p><span class="badge bg-success">POST</span> <code>/api/v1/whatsapp/send</code></p>
                        <h6>{{ __('parameters') }}:</h6>
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>{{ __('parameter') }}</th>
                                    <th>{{ __('type') }}</th>
                                    <th>{{ __('required') }}</th>
                                    <th>{{ __('description') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><code>phone</code></td>
                                    <td>string</td>
                                    <td>{{ __('yes') }}</td>
                                    <td>{{ __('phone_number_with_country_code') }}</td>
                                </tr>
                                <tr>
                                    <td><code>message</code></td>
                                    <td>string</td>
                                    <td>{{ __('yes') }}</td>
                                    <td>{{ __('message_content') }}</td>
                                </tr>
                                <tr>
                                    <td><code>account</code></td>
                                    <td>string</td>
                                    <td>{{ __('no') }}</td>
                                    <td>{{ __('whatsapp_account_unique') }}</td>
                                </tr>
                                <tr>
                                    <td><code>type</code></td>
                                    <td>string</td>
                                    <td>{{ __('no') }}</td>
                                    <td>text, image, video, document, audio</td>
                                </tr>
                                <tr>
                                    <td><code>media_url</code></td>
                                    <td>string</td>
                                    <td>{{ __('no') }}</td>
                                    <td>{{ __('media_url_for_attachments') }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </section>
                    
                    <section id="contacts" class="mb-5">
                        <h3>{{ __('contacts') }}</h3>
                        <p><span class="badge bg-primary">GET</span> <code>/api/v1/contacts</code></p>
                        <p><span class="badge bg-success">POST</span> <code>/api/v1/contacts</code></p>
                        <p><span class="badge bg-warning">PUT</span> <code>/api/v1/contacts/{id}</code></p>
                        <p><span class="badge bg-danger">DELETE</span> <code>/api/v1/contacts/{id}</code></p>
                    </section>
                    
                    <section id="messages" class="mb-5">
                        <h3>{{ __('messages') }}</h3>
                        <p><span class="badge bg-primary">GET</span> <code>/api/v1/messages/sent</code></p>
                        <p><span class="badge bg-primary">GET</span> <code>/api/v1/messages/received</code></p>
                        <p><span class="badge bg-primary">GET</span> <code>/api/v1/messages/{id}</code></p>
                    </section>
                    
                    <section id="devices" class="mb-5">
                        <h3>{{ __('devices') }}</h3>
                        <p><span class="badge bg-primary">GET</span> <code>/api/v1/devices</code></p>
                        <p><span class="badge bg-primary">GET</span> <code>/api/v1/devices/{id}</code></p>
                    </section>
                    
                    <section id="errors" class="mb-5">
                        <h3>{{ __('error_codes') }}</h3>
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>{{ __('code') }}</th>
                                    <th>{{ __('description') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr><td>200</td><td>{{ __('success') }}</td></tr>
                                <tr><td>400</td><td>{{ __('bad_request') }}</td></tr>
                                <tr><td>401</td><td>{{ __('unauthorized') }}</td></tr>
                                <tr><td>403</td><td>{{ __('forbidden') }}</td></tr>
                                <tr><td>404</td><td>{{ __('not_found') }}</td></tr>
                                <tr><td>429</td><td>{{ __('rate_limited') }}</td></tr>
                                <tr><td>500</td><td>{{ __('server_error') }}</td></tr>
                            </tbody>
                        </table>
                    </section>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
